<?php
// +----------------------------------------------------------------------+
// | BoletoPhp - Verso Beta                                              |
// +----------------------------------------------------------------------+
// | Este arquivo est disponvel sob a Licena GPL disponvel pela Web   |
// | em http://pt.wikipedia.org/wiki/GNU_General_Public_License           |
// | Voc deve ter recebido uma cpia da GNU Public License junto com     |
// | esse pacote; se no, escreva para:                                   |
// |                                                                      |
// | Free Software Foundation, Inc.                                       |
// | 59 Temple Place - Suite 330                                          |
// | Boston, MA 02111-1307, USA.                                          |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Originado do Projeto BBBoletoFree que tiveram colaboraes de Daniel |
// | William Schultz e Leandro Maniezo que por sua vez foi derivado do	  |
// | PHPBoleto de Joo Prado Maia e Pablo Martins F. Costa				  |
// | 																	  |
// | Se vc quer colaborar, nos ajude a desenvolver p/ os demais bancos :-)|
// | Acesse o site do Projeto BoletoPhp: www.boletophp.com.br             |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Equipe Coordenao Projeto BoletoPhp: <boletophp@boletophp.com.br>   |
// | Desenvolvimento Boleto Sudameris: Flvio Yutaka Nakamura             |
// +----------------------------------------------------------------------+


$codigobanco         = "347";
$codigo_banco_com_dv = geraCodigoBanco($codigobanco);
$nummoeda            = "9";
$fator_vencimento    = fator_vencimento($dadosboleto["data_vencimento"]);

//valor tem 10 digitos, sem virgula
$valor    = formata_numero($dadosboleto["valor_boleto"], 10, 0, "valor");
//agencia  4 digitos
$agencia  = formata_numero($dadosboleto["agencia"], 4, 0);
//conta  7 digitos
$conta    = formata_numero($dadosboleto["conta"], 7, 0);
//nosso nmero: 13 digitos
$nossonum = formata_numero($dadosboleto["nosso_numero"], 13, 0);

// Calcula o Digito da Cobrana
$digitao = modulo_10($nossonum . $agencia . $conta);
if ($digitao == 10) $digitao = 0;

// 43 numeros para o calculo do digito verificador do codigo de barras
$dv = modulo_11($codigobanco . $nummoeda . $fator_vencimento . $valor . $agencia . $conta . $digitao . $nossonum, 9, 1);
$dv = ($dv == 0 || $dv == 1) ? 1 : 11 - $dv;

// Dados finais
$dadosboleto["codigo_barras"]       = $codigobanco . $nummoeda . $dv . $fator_vencimento . $valor . $agencia . $conta . $digitao . $nossonum;
$dadosboleto["linha_digitavel"]     = monta_linha_digitavel($codigobanco . $nummoeda . $agencia . $conta . $digitao . $nossonum . $dv . $fator_vencimento . $valor);
$dadosboleto["agencia_codigo"]      = $agencia . '/' . $conta . '/' . $digitao;
$dadosboleto["nosso_numero"]        = $nossonum;
$dadosboleto["codigo_banco_com_dv"] = $codigo_banco_com_dv;

// FUNES
// Algumas foram retiradas do Projeto PhpBoleto e modificadas para atender as particularidades de cada banco

function formata_numero($numero,$loop,$insert,$tipo = "geral") {
	if ($tipo == "geral") {
		$numero = str_replace(",","",$numero);
		while(strlen($numero)<$loop){
			$numero = $insert . $numero;
		}
	}
	if ($tipo == "valor") {
		/*
		retira as virgulas
		formata o numero
		preenche com zeros
		*/
		$numero = str_replace(",","",$numero);
		while(strlen($numero)<$loop){
			$numero = $insert . $numero;
		}
	}
	if ($tipo = "convenio") {
		while(strlen($numero)<$loop){
			$numero = $numero . $insert;
		}
	}
	return $numero;
}


function fbarcode($valor){

$fino = 1 ;
$largo = 3 ;
$altura = 50 ;

  $barcodes[0] = "00110" ;
  $barcodes[1] = "10001" ;
  $barcodes[2] = "01001" ;
  $barcodes[3] = "11000" ;
  $barcodes[4] = "00101" ;
  $barcodes[5] = "10100" ;
  $barcodes[6] = "01100" ;
  $barcodes[7] = "00011" ;
  $barcodes[8] = "10010" ;
  $barcodes[9] = "01010" ;
  for($f1=9;$f1>=0;$f1--){ 
    for($f2=9;$f2>=0;$f2--){  
      $f = ($f1 * 10) + $f2 ;
      $texto = "" ;
      for($i=1;$i<6;$i++){ 
        $texto .=  substr($barcodes[$f1],($i-1),1) . substr($barcodes[$f2],($i-1),1);
      }
      $barcodes[$f] = $texto;
    }
  }


//Desenho da barra


//Guarda inicial
?><img src=imagens/p.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img 
src=imagens/b.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img 
src=imagens/p.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img 
src=imagens/b.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img 
<?php
$texto = $valor ;
if((strlen($texto) % 2) <> 0){
	$texto = "0" . $texto;
}

// Draw dos dados
while (strlen($texto) > 0) {
  $i = round(esquerda($texto,2));
  $texto = direita($texto,strlen($texto)-2);
  $f = $barcodes[$i];
  for($i=1;$i<11;$i+=2){
    if (substr($f,($i-1),1) == "0") {
      $f1 = $fino ;
    }else{
      $f1 = $largo ;
    }
?>
    src=imagens/p.png width=<?php echo $f1?> height=<?php echo $altura?> border=0><img 
<?php
    if (substr($f,$i,1) == "0") {
      $f2 = $fino ;
    }else{
      $f2 = $largo ;
    }
?>
    src=imagens/b.png width=<?php echo $f2?> height=<?php echo $altura?> border=0><img 
<?php
  }
}

// Draw guarda final
?>
src=imagens/p.png width=<?php echo $largo?> height=<?php echo $altura?> border=0><img 
src=imagens/b.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img 
src=imagens/p.png width=<?php echo 1?> height=<?php echo $altura?> border=0> 
  <?php
} //Fim da funo

function esquerda($entra,$comp){
	return substr($entra,0,$comp);
}

function direita($entra,$comp){
	return substr($entra,strlen($entra)-$comp,$comp);
}

function fator_vencimento($data) {
	$data = split("/",$data);
	$ano = $data[2];
	$mes = $data[1];
	$dia = $data[0];
    return(abs((_dateToDays("1997","10","07")) - (_dateToDays($ano, $mes, $dia))));
}

function _dateToDays($year,$month,$day) {
    $century = substr($year, 0, 2);
    $year = substr($year, 2, 2);
    if ($month > 2) {
        $month -= 3;
    } else {
        $month += 9;
        if ($year) {
            $year--;
        } else {
            $year = 99;
            $century --;
        }
    }
    return ( floor((  146097 * $century)    /  4 ) +
            floor(( 1461 * $year)        /  4 ) +
            floor(( 153 * $month +  2) /  5 ) +
                $day +  1721119);
}

function modulo_10($num) { 
		$numtotal10 = 0;
        $fator = 2;

        // Separacao dos numeros
        for ($i = strlen($num); $i > 0; $i--) {
            // pega cada numero isoladamente
            $numeros[$i] = substr($num,$i-1,1);
            // Efetua multiplicacao do numero pelo (falor 10)
            // 2002-07-07 01:33:34 Macete para adequar ao Mod10 do Ita
            $temp = $numeros[$i] * $fator; 
            $temp0=0;
            foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
            $parcial10[$i] = $temp0; //$numeros[$i] * $fator;
            // monta sequencia para soma dos digitos no (modulo 10)
            $numtotal10 += $parcial10[$i];
            if ($fator == 2) {
                $fator = 1;
            } else {
                $fator = 2; // intercala fator de multiplicacao (modulo 10)
            }
        }
		
        // vrias linhas removidas, vide funo original
        // Calculo do modulo 10
        $resto = $numtotal10 % 10;
        $digito = 10 - $resto;
        if ($resto == 0) {
            $digito = 0;
        }
		
        return $digito;
		
}

function modulo_11($num, $base=9, $r=0)  {
    /**
     *   Autor:
     *           Pablo Costa <pablo@users.sourceforge.net>
     *
     *   Funo:
     *    Calculo do Modulo 11 para geracao do digito verificador 
     *    de boletos bancarios conforme documentos obtidos 
     *    da Febraban - www.febraban.org.br 
     *
     *   Entrada:
     *     $num: string numrica para a qual se deseja calcularo digito verificador;
     *     $base: valor maximo de multiplicacao [2-$base]
     *     $r: quando especificado um devolve somente o resto
     *
     *   Sada:
     *     Retorna o Digito verificador.
     *
     *   Observaes:
     *     - Script desenvolvido sem nenhum reaproveitamento de cdigo pr existente.
     *     - Assume-se que a verificao do formato das variveis de entrada  feita antes da execuo deste script.
     */                                        

    $soma = 0;
    $fator = 2;

    /* Separacao dos numeros */
    for ($i = strlen($num); $i > 0; $i--) {
        // pega cada numero isoladamente
        $numeros[$i] = substr($num,$i-1,1);
        // Efetua multiplicacao do numero pelo falor
        $parcial[$i] = $numeros[$i] * $fator;
        // Soma dos digitos
        $soma += $parcial[$i];
        if ($fator == $base) {
            // restaura fator de multiplicacao para 2 
            $fator = 1;
        }
        $fator++;
    }

    /* Calculo do modulo 11 */
    if ($r == 0) {
        $soma *= 10;
        $digito = $soma % 11;
        if ($digito == 10) {
            $digito = 0;
        }
        return $digito;
    } elseif ($r == 1){
        $resto = $soma % 11;
        return $resto;
    }
}

function geraCodigoBanco($numero) {
	$parte1 = substr($numero, 0, 3);
	$parte2 = modulo_11($parte1);
	return $parte1 . "-" . $parte2;
}

function monta_linha_digitavel($dados) {
	// Padro: Sudameris
	// POSIO	CONTEDO
	// 1 a 3	Nmero do banco
	// 4		Cdigo da Moeda
	// 5 a 8	Agncia
	// 9 a 15	Conta
	// 16		Digito
	// 17 a 29	Nosso nmero
	// 30		Dgito do cdigo de barra
	// 31 a 34	Fator de vencimento
	// 35 a 44	Valor

	if (ereg('^([0-9]{5})([0-9]{4})([0-9]{5})([0-9]{5})([0-9]{5})([0-9]{5})([0-9]{1})([0-9]{4})([0-9]{10})$', $dados, $bloco))
		{
		$dv1 = modulo_10($bloco[1] . $bloco[2]);
		if ($dv1 == 10) $dv1 = 0;

		$dv2 = modulo_10($bloco[3] . $bloco[4]);
		if ($dv2 == 10) $dv2 = 0;

		$dv3 = modulo_10($bloco[5] . $bloco[6]);
		if ($dv3 == 10) $dv3 = 0;

		return ($bloco[1] . '.' . $bloco[2] . $dv1 . ' ' . $bloco[3] . '.' . $bloco[4] . $dv2 . ' ' . $bloco[5] . '.' . $bloco[6] . $dv3 . ' ' . $bloco[7] . ' ' . $bloco[8] . $bloco[9]);
		}
	else
		return '';
}
?>
